<?php
function save($sock, $object, $prop)
{
   if (isset($object[0][0][$prop])) {
      switch ($object[0][0][$prop]) {
         case 1:
            $result = 1;
            break;
         case 11:
            $result = 101;
            break;
         default:
            $result = $object[0][0][$prop] * 10;
      }
      ParamSetInt($sock, "server.access.$prop", $result);
   }
}
function convertFromBinaryToNum($sock, $arr, $user_index)
{
   if ($arr["ptz"] == 0) {
      ParamSetInt($sock, "security.user.[$user_index].deny.misc.ptz", 16);
   }
   if ($arr["play"] == 0) {
      ParamSetInt($sock, "security.user.[$user_index].deny.misc.play", 24);
      ParamSetInt($sock, "security.user.[$user_index].deny.misc.ptz", 16);
   }
   if ($arr["play"] == 1 && $arr["j_play"] == 0) {
      ParamSetInt($sock, "security.user.[$user_index].deny.misc.play", 8);
   }
   if ($arr["write"] == 1 && $arr["j_read"] == 0) {
      ParamSetInt($sock, "security.user.[$user_index].deny.misc.write", 16);
   }
   if ($arr["write"] == 0) {
      ParamSetInt($sock, "security.user.[$user_index].deny.misc.write", 24);
   }
   if ($arr["read"] == 1 && $arr["j_read"] == 0) {
      ParamSetInt($sock, "security.user.[$user_index].deny.misc.read", 8);
   }
   if ($arr["read"] == 0) {
      ParamSetInt($sock, "security.user.[$user_index].deny.misc.play", 24);
      ParamSetInt($sock, "security.user.[$user_index].deny.misc.ptz", 16);
      ParamSetInt($sock, "security.user.[$user_index].deny.misc.write", 24);
      ParamSetInt($sock, "security.user.[$user_index].deny.misc.read", 24);
   }

   if (
      $arr["read"] == 1 &&
      $arr["write"] == 1 &&
      $arr["play"] == 1 &&
      $arr["ptz"] == 1 &&
      $arr["j_read"] == 1 &&
      $arr["j_play"] == 1
   ) {
      ParamUnset($sock, "security.user.[$user_index].deny.misc.*");
   }
   if ($arr["ptz"] == 1) {
      ParamUnset($sock, "security.user.[$user_index].deny.misc.ptz");
   }
   if ($arr["write"] == 1) {
      ParamUnset($sock, "security.user.[$user_index].deny.misc.write");
   }
   if ($arr["read"] == 1 && $arr["j_read"] == 1) {
      ParamUnset($sock, "security.user.[$user_index].deny.misc.read");
   }
}
function checkObject($arr, $index)
{
   foreach ($arr as $obj) {
      if ($obj->index == $index) {
         return $obj;
      }
   }
}
function saveUserPolicyCamera($sock, $user, $index, $user_server, $key)
{
   if (isset($user_server->deny) && isset($user_server->deny->camera)) {
      $camera = sort_nested_arrays($user_server->deny->camera, ["index" => "desc"]);
      if (!isset($camera[$index]->$key) || $camera[$index]->$key != $user[$key]) {
         ParamSetInt(
            $sock,
            "security.user.[" . $user_server->index . "].deny.camera.[" . $index . "]." . $key,
            $user[$key]
         );
      }
   } else {
      ParamSetInt(
         $sock,
         "security.user.[" . $user_server->index . "].deny.camera.[" . $index . "]." . $key,
         $user[$key]
      );
   }
}
function saveUserPolicySound($sock, $user, $index, $user_server, $key, $key_server)
{
   if (isset($user_server->deny) && isset($user_server->deny->sound)) {
      $sound = sort_nested_arrays($user_server->deny->sound, ["index" => "desc"]);
      if (isset($sound)) {
         if (!isset($sound[$index]->$key_server) || $sound[$index]->$key_server != $user[$key]) {
            ParamSetInt(
               $sock,
               "security.user.[" . $user_server->index . "].deny.sound.[" . $index . "]." . $key_server,
               $user[$key]
            );
         }
      }
   } else {
      ParamSetInt(
         $sock,
         "security.user.[" . $user_server->index . "].deny.sound.[" . $index . "]." . $key_server,
         $user[$key]
      );
   }
}

function changeUserLvlPolicy($sock, $user, $access, $index)
{
   if (isset($user->accesslevel)) {
      if ($user->accesslevel != $access) {
         ParamSetInt($sock, "security.user.[" . $index . "].accesslevel", $access);
      }
   } else {
      ParamSetInt($sock, "security.user.[" . $index . "].accesslevel", $access);
   }
}

function dispatchServer($sock, $user, $user_index, $arr)
{
   if (!isset($user)) {
      return;
   }

   if (isset($arr[6])) {
      $access = $arr[6] * 10;
      changeUserLvlPolicy($sock, $user, $access, $user_index);
   }

   if (isset($arr[5]) && count($arr[5]) > 0) {
      $journal_and_server = $arr[5];
      convertFromBinaryToNum($sock, $journal_and_server, $user_index);
   }

   if (isset($user) && isset($user->deny)) {
      if (!isset($user->deny->sound)) {
         ParamSetInt($sock, "security.user.[$user_index].deny.sound.[0].index", 0);
         ParamSetInt($sock, "security.user.[$user_index].deny.sound.[1].index", 1);
         ParamSetInt($sock, "security.user.[$user_index].deny.sound.[2].index", 2);
         ParamSetInt($sock, "security.user.[$user_index].deny.sound.[3].index", 3);
      }
      if (!isset($user->deny->camera)) {
         ParamSetInt($sock, "security.user.[$user_index].deny.camera.[0].index", 0);
         ParamSetInt($sock, "security.user.[$user_index].deny.camera.[1].index", 1);
         ParamSetInt($sock, "security.user.[$user_index].deny.camera.[2].index", 2);
         ParamSetInt($sock, "security.user.[$user_index].deny.camera.[3].index", 3);
      }
   }

   for ($i = 0; $i < 4; $i++) {
      foreach ($arr[$i] as $key => $value) {
         if ($key == "soundRead" || $key == "soundPlay") {
            $path = $key == "soundRead" ? "read" : "play";
            saveUserPolicySound($sock, $arr[$i], $i, $user, $key, $path);
         } else {
            saveUserPolicyCamera($sock, $arr[$i], $i, $user, $key);
         }
      }
   }
}
function updateCamera($sock, $index, $countBlock, $value, $oldValue)
{
   $array = ["read", "write", "play", "ptz"];
   foreach ($array as $item) {
      if ($value[$item] != $oldValue->$item) {
         ParamSetInt($sock, "security.user.[$index].deny.camera.[$countBlock]." . $item, $value[$item]);
      }
   }
}
function updateSound($sock, $index, $countBlock, $name, $value, $oldValue)
{
   if ($value != $oldValue) {
      ParamSetInt($sock, "security.user.[$index].deny.sound.[$countBlock]." . $name, $value);
   }
}
function getItem($arr, $index)
{
   foreach ($arr as $obj) {
      if ($obj->index == $index) {
         $itemAudio = $obj->access;
      }
   }
   return $itemAudio;
}
function saveVideo($sock, $value, $index, $oldValue, $name)
{
   $value = intval($value) === 11 ? 101 : intval($value) * 10;
   if ($oldValue != $value) {
      ParamSetInt($sock, "video.input.[" . $index . "].access." . $name, $value);
   }
}
function saveAudio($sock, $value, $index, $oldValue, $name)
{
   $value = intval($value) === 11 ? 101 : intval($value) * 10;
   if ($oldValue != $value) {
      ParamSetInt($sock, "audio.input.[" . $index . "].access." . $name, $value);
   }
}
